//
//  CheckBox.swift
//  E-commerce
//
//  Created by Yahya Tabba on 11/14/18.
//  Copyright © 2018 Autotech Co. All rights reserved.
//

import Foundation
import UIKit

class CheckBox: UIButton {
    // Images
    var checkedImage : UIImage = #imageLiteral(resourceName: "baseline_radio_button_checked_black_24pt") // #imageLiteral(resourceName: "icons8-checked")
    var uncheckedImage : UIImage = #imageLiteral(resourceName: "baseline_radio_button_unchecked_black_24pt")  // #imageLiteral(resourceName: "icons8-unchecked")
    
    // Bool property
    var isChecked: Bool = false {
        didSet{
            if isChecked == true {
                self.setImage(checkedImage, for: UIControl.State.normal)
            } else {
                self.setImage(uncheckedImage, for: UIControl.State.normal)
            }
        }
    }
    
    override func awakeFromNib() {
//        self.addTarget(self, action:#selector(buttonClicked(_:)), for: UIControl.Event.touchUpInside)
        self.isChecked = false
    }
    
    @objc func buttonClicked(_ sender: UIButton) {
        if sender == self {
            isChecked = !isChecked
        }
    }
}
